/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取ganma表相关数据
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported  mc_gamma_get_send_value */

/* exported  mc_gamma_chip_get_default_data */
/* exported  mc_gamma_constructor_tbl */
/* exported  mc_gamma_shrink_count */
/* exported  mc_gamma_box_get_default_data */
/* exported  mc_read_box_gamma */
/* exported  mc_send_box_gamma */
/* exported  mc_preserve_box_gamma */


/* global $ */
/* global mc_sdk_param */


//全局参数
// cmd
var JSON_CMD_PARAM = "GET_PARAM";


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma发送值
 * 参数:
 *    @param {Promise<string>}
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 ************************************************************************************************/

/* function mc_gamma_get_send_value(fun_callback) {
    var str_gamma_json_req = new mc_sdk_param();

    str_gamma_json_req.set_param_clear();
    str_gamma_json_req.set_cmd(JSON_CMD_PARAM);
    str_gamma_json_req.set_func("RECVCARD_GAMA");
    str_gamma_json_req.set_param_value(JSON_BOX_NAME_PARAM, "");
    str_gamma_json_req.get_attr_val(JSON_BOX_NAME_PARAM, "GAMA_R");
    str_gamma_json_req.get_attr_val(JSON_BOX_NAME_PARAM, "GAMA_G");
    str_gamma_json_req.get_attr_val(JSON_BOX_NAME_PARAM, "GAMA_B");
    str_gamma_json_req.get_attr_val(JSON_BOX_NAME_PARAM, "GAMA_FIRST_CODE", "ZZ1");
    $.post("/access_shell", str_gamma_json_req.get_json(), function (result) {
        fun_callback(result);
        return;
    });
} */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma默认表 拿到初始数据 渲染到页面
 * 参数:
 *    @param {Promise<function>} fun_callback               回调函数
 *    @param {Promise<string>} str_url_gama_mode_value          Gamma模式
 *    @param {Promise<string>} str_bright_percent_value    亮度百分比
 *    @param {Promise<string>} str_pix_input_bit_size_value  输入源位宽
 *    @param {Promise<string>} str_url_gray_bit_size      灰度等级
 *    @param {Promise<string>} str_max_val      最大值
 *    @param {Promise<string>} str_url_gamma_factor           灰度计算因子

 * 返回：
 *      String : gamma值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_constructor_tbl(fun_callback, str_url_gama_mode_value, str_bright_percent_value, str_pix_input_bit_size_value, str_url_gray_bit_size, str_max_val, str_url_gamma_factor) {
    mc_gamma_get_gamma(function (ary_gamma_tbl) {
        fun_callback(ary_gamma_tbl);
    }, str_url_gama_mode_value, str_bright_percent_value, str_pix_input_bit_size_value, str_url_gray_bit_size, str_max_val, str_url_gamma_factor);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma默认表 拿到初始数据 并处理
 * 参数:
 *    @param {Promise<function>} fun_callback               回调函数
 *    @param {Promise<string>} str_url_gama_mode_value          Gamma模式
 *    @param {Promise<string>} str_bright_percent_value    亮度百分比
 *    @param {Promise<string>} str_pix_input_bit_size_value  输入源位宽
 *    @param {Promise<string>} str_url_gray_bit_size      灰度等级
 *    @param {Promise<string>} str_max_val      最大值
 *    @param {Promise<string>} str_url_gamma_factor         灰度计算因子

 * 返回：
 *      String : gamma值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_get_gamma(fun_callback, str_url_gama_mode_value, str_bright_percent_value, str_pix_input_bit_size_value, str_url_gray_bit_size, str_max_val, str_url_gamma_factor) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    if ("string" !== typeof str_url_gray_bit_size || 0 >= str_url_gray_bit_size.length) {
        str_url_gray_bit_size = "12";
    }


    if ("string" !== typeof str_url_gamma_factor || 1 > parseFloat(str_url_gamma_factor) || 4 < parseFloat(str_url_gamma_factor) || 0 >= str_url_gamma_factor.length) {
        str_url_gamma_factor = "2.8";
    }


    if ("string" !== typeof str_url_gama_mode_value || 0 > parseInt(str_url_gama_mode_value, 10) || 2 < parseInt(str_url_gama_mode_value, 10)) {
        str_url_gama_mode_value = "1";
    }
    if ("string" !== typeof str_max_val || 0 > parseInt(str_max_val, 10)) {
        str_max_val = "65535";
    }

    var str_default_gamma_json_req = new mc_sdk_param();

    str_default_gamma_json_req.set_param_clear();
    str_default_gamma_json_req.set_cmd(JSON_CMD_PARAM);
    str_default_gamma_json_req.set_func("GAMA_TABLE");
    str_default_gamma_json_req.set_param_value("GAMA_MODE", str_url_gama_mode_value);
    str_default_gamma_json_req.set_param_value("BRIGHT_PERCENT", "100");
    str_default_gamma_json_req.set_param_value("PIX_INPUT_BIT_SIZE", "8");
    str_default_gamma_json_req.set_param_value("GRAY_BIT_SIZE", str_url_gray_bit_size);
    str_default_gamma_json_req.set_param_value("GAMA_MAX_VAL", str_max_val);
    str_default_gamma_json_req.set_param_value("GAMA_FACTOR", str_url_gamma_factor);

    $.post("/access_shell", str_default_gamma_json_req.get_json(), function (result, status) {
        if ("success" === status) {
            var obj_param_gamma = new mc_sdk_param();

            obj_param_gamma.set_json(result);
            var str_gamma_tbl = obj_param_gamma.get_param_value("GAMA_TABLE");


            //清除空白 改逗号为英文 去掉重复逗号
            var ary_gamma_tbl = str_gamma_tbl.replace(/，/ig, ",").replace(/\s*/g, "").split(",");

            for (var i = 0; i < ary_gamma_tbl.length; i++) {
                if ("" === ary_gamma_tbl[i]) {
                    str_gamma_tbl.splice(i, 1);
                    i--;
                }
            }

            ary_gamma_tbl = str_gamma_tbl.split(",");

            fun_callback(ary_gamma_tbl);
        }
    });
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取算数后的gamma表 拿到初始数据 并处理
 * 参数:
 *    @param {Promise<function>} fun_callback     回调函数
 *    @param {Promise<string>} str_gamma_tbl     GAMMA表灰度
 *    @param {Promise<integer>} int_percent     百分百 (默认100)

 * 返回：
 *      String : gamma缩小值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_shrink_count(fun_callback, str_gamma_tbl, int_percent) {
    /* if ("function" !== typeof fun_callback) {

fun_callback("");
return;
} */
    var str_shrink_gamma_json_req = new mc_sdk_param();

    str_shrink_gamma_json_req.set_param_clear();
    str_shrink_gamma_json_req.set_cmd(JSON_CMD_PARAM);
    str_shrink_gamma_json_req.set_func("GAMA_TABLE_SCAL");
    str_shrink_gamma_json_req.set_param_value("GAMA_TABLE", str_gamma_tbl);
    str_shrink_gamma_json_req.set_param_value("PERCENT", int_percent);

    $.post("/access_shell", str_shrink_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_param_shrink_gamma = new mc_sdk_param();

        obj_param_shrink_gamma.set_json(result);
        var str_shrink_gamma_tbl = obj_param_shrink_gamma.get_param_value("GAMA_TABLE");

        fun_callback(str_shrink_gamma_tbl);

        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    通过芯片获取初始gamma值
 * 参数:
 *    @param {Promise<function>} fun_callback     回调函数
 *    @param {Promise<string>} str_Disp_Chip      显示芯片名称
 *    @param {Promise<string>} str_Ctrl_Chip     主控芯片名称
 * 返回：
 *    @param {Promise<number>} ui_attr_name_count     参数属性的个数
 *    @param {Promise<array>} arr_attr_name           所有参数的名字
 *    @param {Promise<array>} arr_attr_val            所有参数的数据
 * 修改:,
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.31
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_chip_get_default_data(fun_callback, str_Disp_Chip, str_Ctrl_Chip) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var str_chip_gamma_json_req = new mc_sdk_param();

    str_chip_gamma_json_req.set_param_clear();
    str_chip_gamma_json_req.set_cmd(JSON_CMD_PARAM);
    str_chip_gamma_json_req.set_func("DISPCHIP_GAMA_GRP");
    str_chip_gamma_json_req.set_param_value(str_Disp_Chip, str_Ctrl_Chip);

    $.post("/access_shell", str_chip_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        var obj_param_chip_gamma = new mc_sdk_param();

        obj_param_chip_gamma.set_json(result);
        // var str_disp_chip_gamma_tbl = obj_param_chip_gamma.get_param_value(str_Disp_Chip);

        // console.log(result);

        var ui_attr_name_count = obj_param_chip_gamma.get_attr_cnt(str_Disp_Chip);

        if (0 === ui_attr_name_count.length) {
            return;
        }

        var str_attr_name_index = "";
        var arr_attr_name = [];

        for (var i = 0; i < ui_attr_name_count; i++) {
            str_attr_name_index = obj_param_chip_gamma.get_attr_name(str_Disp_Chip, i);
            arr_attr_name.push(str_attr_name_index);
        }
        var str_attr_name_value = "";
        var arr_attr_val = [];

        for (var k = 0; k < arr_attr_name.length; k++) {
            str_attr_name_value = obj_param_chip_gamma.get_attr_val(str_Disp_Chip, arr_attr_name[k]);
            arr_attr_val.push(str_attr_name_value);
        }

        fun_callback(ui_attr_name_count, arr_attr_name, arr_attr_val);

        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    通过箱体获取初始gamma值
 * 参数:
 *    @param {Promise<function>} fun_callback     回调函数
 *    @param {Promise<string>} str_url_box_name      箱体名称
 *    @param {Promise<string>} str_max_val      箱体名称

 * 返回：
 *    @param {Promise<Number>}
 *    @param {Promise<array>}
 *    @param {Promise<array>}
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.31
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_box_get_default_data(fun_callback, str_url_box_name, str_max_val) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }

    var str_box_gamma_json_req = new mc_sdk_param();


    str_box_gamma_json_req.set_param_clear();
    str_box_gamma_json_req.set_cmd(JSON_CMD_PARAM);
    str_box_gamma_json_req.set_func("RECVCARD_DEF_GAMA");
    str_box_gamma_json_req.set_param_value(str_url_box_name, "");
    str_box_gamma_json_req.set_attr_val(str_url_box_name, "GAMA_MAX_VAL", str_max_val);
    // str_box_gamma_json_req.set_attr_val(str_url_dispchip,"GAMA_FACTOR","2.8");
    // str_box_gamma_json_req.set_attr_val(str_url_dispchip,"BRIGHT_PERCENT_R","100");
    // str_box_gamma_json_req.set_attr_val(str_url_dispchip,"BRIGHT_PERCENT_G","100");
    // str_box_gamma_json_req.set_attr_val(str_url_dispchip,"BRIGHT_PERCENT_B","100");

    $.post("/access_shell", str_box_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_param_box_gamma = new mc_sdk_param();

        obj_param_box_gamma.set_json(result);

        var str_box_attr_r_val = obj_param_box_gamma.get_attr_val(str_url_box_name, "GAMA_R");
        // console.log(obj_param_box_gamma.get_attr_name("mc_box_54321",2));

        fun_callback(str_box_attr_r_val);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取箱体GAMMA表(回读)
 * 参数:
 *    @param {Promise<StringConstructor>} str_order    命令指令
 *    @param {Promise<StringConstructor>} str_cur_ctrl_card    主控芯片名称 (可能没有)
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<Number>}
 *    @param {Promise<array>}
 *    @param {Promise<array>}
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.4.26
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_read_box_gamma(str_order, str_cur_ctrl_card, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var str_box_gamma_json_req = new mc_sdk_param();

    str_box_gamma_json_req.set_param_clear();
    str_box_gamma_json_req.set_cmd("GET_PARAM");
    str_box_gamma_json_req.set_func("HW_BOX_GAMA");
    str_box_gamma_json_req.set_param_value("RECVCARD", str_order);
    str_box_gamma_json_req.set_attr_val("RECVCARD", "CHIPNAME", str_cur_ctrl_card);
    str_box_gamma_json_req.set_attr_val("RECVCARD", "MEMTYPE", "RAM");

    $.post("/access_shell", str_box_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_param_box_gamma = new mc_sdk_param();

        obj_param_box_gamma.set_json(result);
        var str_val_json = obj_param_box_gamma.get_param_value("RW_DATA");
        var obj_color = new mc_sdk_param();

        obj_color.set_json(str_val_json);
        var str_gamma_r = obj_color.get_param_value("R");
        // var str_gamma_g = obj_param_box_gamma.get_param_value("GAMA_G");
        // var str_gamma_b = obj_param_box_gamma.get_param_value("GAMA_B");
        var str_gamma_id = obj_param_box_gamma.get_param_value("GAMA_ID");
        var str_error = obj_param_box_gamma.get_param_value("ERROR_CODE");

        var obj_box_gamma = {
            "str_gamma_r": str_gamma_r,
            // "str_gamma_g": str_gamma_g,
            // "str_gamma_b": str_gamma_b,
            "str_gamma_id": str_gamma_id,
            "error": str_error
        };


        fun_callback(obj_box_gamma);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体GAMMA表(发送)
 * 参数:
 *    @param {Promise<String>} str_order     命令
 *    @param {Promise<String>} str_date     要发送的数据
 *    @param {Promise<String>} str_cur_ctrl_card     主控芯片名称
 *    @param {Promise<String>} str_way     发送或固化
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<Number>}
 *    @param {Promise<array>}
 *    @param {Promise<array>}
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.6.28
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_send_box_gamma(str_order, str_date, str_cur_ctrl_card, str_way, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }

    var str_workmode = "0";

    if ("RAM" === str_way) {
        if (parent.b_if_mass) {
            str_workmode = "1";
        }
    }
    if ("FLASH" === str_way) {
        if (parent.b_if_mass) {
            str_workmode = "1";
        }
        if (parent.b_if_mirror) {
            str_workmode = "2";
        }
        if (parent.b_if_mass && parent.b_if_mirror) {
            str_workmode = "3";
        }
    }
    var str_box_gamma_json_req = new mc_sdk_param();

    str_box_gamma_json_req.set_param_clear();
    str_box_gamma_json_req.set_cmd("SET_PARAM");
    str_box_gamma_json_req.set_func("HW_BOX_GAMA");
    str_box_gamma_json_req.set_param_value("RECVCARD", str_order);
    str_box_gamma_json_req.set_attr_val("RECVCARD", "CHIPNAME", str_cur_ctrl_card);
    str_box_gamma_json_req.set_attr_val("RECVCARD", "MEMTYPE", str_way);

    str_box_gamma_json_req.set_attr_val("RECVCARD", "GAMA_R", str_date);
    // str_box_gamma_json_req.set_attr_val("RECVCARD", "WORKMODE", str_workmode);
    // str_box_gamma_json_req.set_attr_val("RECVCARD", "GAMA_G", "");
    // str_box_gamma_json_req.set_attr_val("RECVCARD", "GAMA_B", "");
    // str_box_gamma_json_req.set_attr_val("RECVCARD", "GAMA_ID", "");

    $.post("/access_shell", str_box_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_param_box_gamma = new mc_sdk_param();

        obj_param_box_gamma.set_json(result);
        var error = obj_param_box_gamma.get_param_value("ERROR_CODE");


        fun_callback(error);
        return;
    });
}
